*Counterfactual between-class inequality levels

*Tim Goedemé
*Based on 23_Counterfactual version 2

/*

Creative Commons Attribution-NonCommercial-ShareAlike 4.0 International License. 
This file can be changed and re-shared for non-commercial use, as long as our original work 
is recognised and the revised work is made available under the same conditions.

When using this do-file, please cite as:
Goedemé, T., Nolan, B., Paskov, M., & Weisstanner, D. (2021). 
Occupational Social Class and Earnings Inequality in Europe: A Comparative Assessment. 
In: Social Indicators Research. DOI: https://doi.org/10.1007/s11205-021-02746-z; https://timgoedeme.com/tools/esec-in-eu-silc/

This file makes use of the subprop command which I wrote, but is not available 
online. Please get in touch if you would like to make use of this command.

*/

global place1 <<data directory>>
global place2 <<output directory 1>>
global place3 <<output directory 2>>
global countries AT BE BG CH CY CZ DE DK EE EL ES FI FR HR HU IE IT LT LU LV MT NL NO PL PT RO RS SE SI UK



*Estimating the counterfactual between-class MLD; only SILC 2018 - 9 classes
*****************************************************************************
set matsize 5000, permanent

cap mat drop results	
foreach ctry of global countries {
	di "`ctry'", _continue
	
	quietly {
		local year 2018
		cap use "${place1}\`ctry'\\`year'\c`ctry'`year'_addvars2.dta", clear
		if _rc==0 {
			drop age hydisp eqs hystd thresh60 arop60 actage active
			svyset psu1 [pw=weight], strata(strata1)
			
			replace sub = 0 if missers2!=0
			replace sub = 0 if earns1<=0 | earns2<=0
			
			gen class=esec08
			
			if regexm("DK DE NL MT EE BE CZ NO SE LU CH PT SI CY UK FR IT", "`ctry'")==1 replace class = . if esec08==5 // (class 5 accounts for less than 1.5% of population in paid employment)
			if regexm("DK DE NL MT EE BE CZ NO SE LU CH PT SI CY UK FR IT", "`ctry'")==1 replace sub = 0 if esec08==5 
			
			if "`ctry'"=="DK" replace class = . if (esec08==5 | esec08==4)
			if "`ctry'"=="DK" replace sub = 0 if (esec08==5 | esec08==4)
			
			if "`ctry'"=="RO" replace class = . if (esec08==6)
			if "`ctry'"=="RO" replace sub = 0 if (esec08==6)
			
			drop esec08
			subprop3 class, subpop(sub) na(test)
			local rows=rowsof(test)
			local secondterm
			forvalues x=1/`rows' {
				local c=el(test, `x', 1)
				local s=el(test, `x', 2)/100
				local secondterm `secondterm' -`s'*ln(_b[`c'.class])
				
			}
			if regexm("BG HU PL RO", "`ctry'")==1 global vars c.fyfte i.sex i.education i.health c.career c.nchilds c.nadults c.ndepadults
			else global vars c.fyfte i.sex i.immigrant i.education i.health c.career c.nchilds c.nadults c.ndepadults
			if "`ctry'"=="SI" global vars c.fyfte i.sex i.immigrant c.education i.health c.career c.nchilds c.nadults c.ndepadults
			*BG HU PL and RO: no immigrant variable due to too low prevalence; SI: education as continuous variable as low educated does not occur in high salariat
			

			local conflevel 0.025
			forvalues earnings = 2/2 {
				
								
				*1. Version 1: with interaction terms
				*************************************
				noi di "`earnings':1", _continue

				global interactions
				foreach var of global vars {
					global interactions ${interactions} i.class#`var' 
				}
				
				svy, subpop(sub): reg earns`earnings' i.class ${vars} ${interactions}
				local val1 = e(N_sub)
				
				mat def results = nullmat(results) \ `val1'
				
			}
			
			noi di "."
		}
	}
}
mat rownames results = ${countries}
mat li results

